# Verification report

## SU(3) one-loop extraction

* Running `python scripts/extract_beta.py` generated CSV files (`g_vs_mu.csv`,
  `beta_numeric.csv`) and plots (`g_vs_lnmu.png`, `beta_fit.png`) in
  `results/`.
* The fitted coefficient β₁ was 11.0270 versus the theoretical value
  11.0000, corresponding to a relative error of 0.25%.  This is
  consistent with small statistical noise from the mock sampler.

### Core plots

| | |
|---|---|
| running coupling $g(\mu)$ vs $\ln\mu$ | numerical $\beta(g)$ vs $g$ with one-loop fit |
| ![g_vs_lnmu_thumb](results/g_vs_lnmu_thumb.png) | ![beta_fit_thumb](results/beta_fit_thumb.png) |

### Fit summary

| quantity | fitted value | theoretical | relative error |
|---------|-------------|-------------|---------------|
| β₁ (SU(3)) | 11.0270 | 11.0000 | 0.25% |

## SU(N) scaling analysis

* Running `python scripts/extract_beta_N.py` in `N_scaling` produced
  CSV files and plots in `N_scaling/results/`.
* The table below summarises the fitted β₁ values for each N together
  with the theoretical expectations and relative errors.

| N | β₁ fit | β₁ theory = 11·N/3 | relative error |
|--|-------|------------------|---------------|
| 2 | 7.1148 | 7.3333 | 2.98% |
| 4 | 14.7893 | 14.6667 | 0.84% |

* A straight‑line fit of β₁ versus N (through the origin) gives a
  slope of 3.6693, while the theoretical slope is 11/3 = 3.6667,
  yielding a relative error of 0.07%.

| parameter | fitted value | theoretical | relative error |
|----------|-------------|-------------|---------------|
| slope (β₁ vs N) | 3.6693 | 3.6667 | 0.07% |

### N-scaling plots

| | |
|---|---|
| β₁ as a function of N with theory line | running coupling $g(\mu)$ vs $\ln\mu$ for N=2,4 |
| ![beta1_scaling_thumb](N_scaling/results/beta1_scaling_thumb.png) | ![g_vs_lnmu_N_thumb](N_scaling/results/g_vs_lnmu_N_thumb.png) |

## Notes

The regenerated CSV files and figures exactly match those produced by
the scripts (apart from insignificant numerical noise due to the
random sampling), so no discrepancies were observed.